@echo off
setlocal

REM Check if the file path was provided as an argument
if "%~1"=="" (
    echo Please provide a file, e.g., config.json
    exit /b 1
)

REM Define the file path and file name
set "input_file=%~1"
set "zip_file=%~n1_encrypted.zip"

REM Prompt for the password
set /p "password=Enter a password for encryption: "

REM 7-Zip command to create the encrypted ZIP archive
7z a -tzip "%zip_file%" "%input_file%" -p"%password%" -mem=AES256

REM Check if the archive was successfully created
if exist "%zip_file%" (
    echo The file was successfully encrypted and saved as %zip_file%.
) else (
    echo Error in creating the zip file.
)

endlocal
